/*************************************************************************
 *    CompuCell - A software framework for multimodel simulations of     *
 * biocomplexity problems Copyright (C) 2003 University of Notre Dame,   *
 *                             Indiana                                   *
 *                                                                       *
 * This program is free software; IF YOU AGREE TO CITE USE OF CompuCell  *
 *  IN ALL RELATED RESEARCH PUBLICATIONS according to the terms of the   *
 *  CompuCell GNU General Public License RIDER you can redistribute it   *
 * and/or modify it under the terms of the GNU General Public License as *
 *  published by the Free Software Foundation; either version 2 of the   *
 *         License, or (at your option) any later version.               *
 *                                                                       *
 * This program is distributed in the hope that it will be useful, but   *
 *      WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    *
 *             General Public License for more details.                  *
 *                                                                       *
 *  You should have received a copy of the GNU General Public License    *
 *     along with this program; if not, write to the Free Software       *
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
 *************************************************************************/

#ifndef SwitchTipStalkSteppable_H
#define SwitchTipStalkSteppable_H

#include <CompuCell3D/plugins/NeighborTracker/NeighborTrackerPlugin.h>
#include <CompuCell3D/plugins/PixelTracker/BoundaryPixelTrackerPlugin.h>
#include <CompuCell3D/plugins/PixelTracker/PixelTrackerPlugin.h>
#include <CompuCell3D/Potts3D/EnergyFunction.h>
#include <CompuCell3D/Potts3D/Cell.h>
#include <CompuCell3D/Potts3D/Potts3D.h>
#include <CompuCell3D/Potts3D/CellGChangeWatcher.h>
#include <CompuCell3D/Steppable.h>
#include <CompuCell3D/Field3D/Dim3D.h>
#include <CompuCell3D/Field3D/Field3D.h>
#include <CompuCell3D/Field3D/WatchableField3D.h>

#include <string>
#include <BasicUtils/BasicRandomNumberGenerator.h>


#include <CompuCell3D/Steppable.h>
#include <CompuCell3D/Field3D/Dim3D.h>
#include <CompuCell3D/Field3D/Point3D.h>

#include <BasicUtils/BasicClassAccessor.h>

#include "../ClusterDataTrackerPlugin/ClusterDataTrackerPlugin.h"


//STL containers
#include <vector>
#include <list>
#include <set>
#include <map>
#include <string>

template <typename Y> class BasicClassAccessor;
class CC3DXMLElement;
namespace CompuCell3D {
      
  template <class T> class WatchableField3D;
  template <class T> class Field3DImpl;
 
    class Potts3D;
    class Automaton;
    class BoundaryStrategy;
    class CellInventory;
    class CellG;
    class Simulator;

  

  class SwitchTipStalkSteppable: public Steppable {
    Simulator * sim;
    Potts3D *potts;
    CC3DXMLElement *xmlData;

    WatchableField3D<CellG *> *fieldG;
    Automaton *automaton;
    BoundaryStrategy *boundaryStrategy;
    CellInventory * cellInventoryPtr;  	
    Dim3D fieldDim;
      
    BasicRandomNumberGenerator * rand; 
    unsigned int maxNeighborIndex;
    
//     Field3D<float> *FPDGFB; 
//     Field3D<float> *FLTGFb;
//     Field3D<float> *FTGFb; 
//     Field3D<float> *FuPAR;
//     Field3D<float> *FuPA;
    Field3D<float> *FuPARact;      
      
  public:
     double createHaploid; 
     double switchStalkTipFate;
     double haploidPercentage;
    double switchStalkTipFateNICDconc;   
  
         Field3DImpl<float>* getCCFieldByName(std::string _fieldName);
        //BasicClassAccessor<NeighborTracker> * neighborTrackerAccessorPtr;
        //NeighborTrackerPlugin *nTrackerPlugin;
        
        BasicClassAccessor <ClusterDataTrackerPlugin> *clusterDataTrackerAccessorPtr;
	ClusterDataTrackerPlugin *clusterDataTrackerPlugin;
        

  
  
    SwitchTipStalkSteppable();
    virtual ~SwitchTipStalkSteppable();
    // SimObject interface
	virtual void init(Simulator *simulator, CC3DXMLElement *_xmlData);
    virtual void extraInit(Simulator *simulator);
    virtual void start();
    virtual void step(const unsigned int currentStep);
    virtual void finish() {}

    //SteerableObject interface
    virtual void update(CC3DXMLElement *_xmlData);
    virtual std::string steerableName();
	virtual std::string toString();
  };
};
#endif
